import type { Metadata } from "next"
import { Suspense } from "react"
import { generatePageMetadata, generateJsonLd } from "@/lib/seo/metadata"
import { StatesClient } from "@/components/admin/states/states-client"
import { Skeleton } from "@/components/ui/skeleton"

export const metadata: Metadata = generatePageMetadata({
  title: "States",
  description:
    "Manage states for the Teertham platform. Add, edit, activate, deactivate, or delete states to control your platform coverage.",
  path: "/admin/states",
  noIndex: true,
})

function StatesLoading() {
  return (
    <div className="admin-section space-y-6">
      <div className="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
        <div className="space-y-2">
          <Skeleton className="h-8 w-32" />
          <Skeleton className="h-4 w-64" />
        </div>
        <Skeleton className="h-10 w-32" />
      </div>
      <div className="space-y-4">
        <Skeleton className="h-10 w-72" />
        <Skeleton className="h-96 w-full rounded-xl" />
      </div>
    </div>
  )
}

export default function StatesPage() {
  const jsonLd = generateJsonLd({
    "@type": "WebPage",
    name: "States Management | Teertham Admin",
    description: "Administrative interface for managing states in the Teertham platform.",
  })

  return (
    <>
      <script type="application/ld+json" dangerouslySetInnerHTML={jsonLd} />
      <main>
        <Suspense fallback={<StatesLoading />}>
          <StatesClient />
        </Suspense>
      </main>
    </>
  )
}
