import type { Metadata } from "next"
import { ManageTeamClient } from "@/components/admin/sub-admin/manage-team-client"

export const metadata: Metadata = {
  title: "Manage Team | Teertham",
  description: "Add and manage team members with role-based access control in the Teertham admin panel.",
  openGraph: {
    title: "Manage Team | Teertham",
    description: "Add and manage team members with role-based access control in the Teertham admin panel.",
    type: "website",
  },
  twitter: {
    card: "summary",
    title: "Manage Team | Teertham",
    description: "Add and manage team members with role-based access control in the Teertham admin panel.",
  },
}

export default function ManageTeamPage() {
  return (
    <main className="space-y-6">
      <header>
        <h1 className="text-2xl font-bold tracking-tight md:text-3xl">Manage Team</h1>
        <p className="text-muted-foreground mt-1">
          Add team members and assign roles to control their access permissions.
        </p>
      </header>
      <ManageTeamClient />
    </main>
  )
}
