import type { Metadata } from "next"
import { Suspense } from "react"
import { HotelPageWrapper } from "@/components/hotel/hotel-page-wrapper"
import { HotelSidebarNav } from "@/components/hotel/hotel-sidebar-nav"
import { BookingsTable } from "@/components/hotel/bookings/bookings-table"
import { BookingsLoadingSkeleton } from "@/components/hotel/bookings/bookings-loading-skeleton"

export const metadata: Metadata = {
  title: "Bookings",
  description: "Manage and track all your hotel reservations and guest bookings",
}

interface BookingsPageProps {
  searchParams: Promise<{ status?: string }>
}

export default async function HotelBookingsPage({ searchParams }: BookingsPageProps) {
  const params = await searchParams
  const status = params.status || "booked"

  return (
    <HotelPageWrapper>
      <div className="space-y-6">
        {/* Page Header */}
        <header>
          <h1 className="text-3xl font-bold tracking-tight text-foreground">Bookings</h1>
          <p className="text-muted-foreground mt-1">Manage and track all your hotel reservations</p>
        </header>

        {/* Main Content Layout */}
        <div className="flex flex-col lg:flex-row gap-6">
          <HotelSidebarNav type="bookings" />
          <main className="flex-1" role="main" aria-label="Bookings content">
            <Suspense fallback={<BookingsLoadingSkeleton />}>
              <BookingsTable status={status} />
            </Suspense>
          </main>
        </div>
      </div>
    </HotelPageWrapper>
  )
}
