import Link from "next/link"
import { AdminSidebarNav } from "./admin-sidebar-nav"

export function AdminSidebarServer() {
  return (
    <aside
      className="fixed left-0 top-0 z-40 hidden md:flex h-screen w-64 flex-col bg-card border-r border-border/40 shadow-lg"
      aria-label="Admin navigation"
    >
      {/* Logo header */}
      <div className="flex items-center gap-3 border-b border-border/40 px-4 py-4 bg-gradient-to-br from-primary/5 to-transparent shrink-0">
        <Link href="/admin/dashboard" className="flex items-center gap-3">
          <div className="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-primary to-primary/80 text-primary-foreground shadow-lg shadow-primary/25">
            <span className="text-lg font-bold">T</span>
          </div>
          <div className="flex flex-col">
            <span className="text-lg font-semibold tracking-tight">Teertham</span>
            <span className="text-[9px] font-bold uppercase tracking-widest bg-gradient-to-r from-primary/20 to-primary/10 text-primary px-2 py-0.5 rounded-md border border-primary/20 w-fit">
              Admin
            </span>
          </div>
        </Link>
      </div>

      {/* Navigation - client component for interactive state */}
      <div className="flex-1 overflow-y-auto px-3 py-3 scrollbar-thin scrollbar-thumb-border scrollbar-track-transparent hover:scrollbar-thumb-border/80">
        <AdminSidebarNav />
      </div>

      <div className="border-t border-border/40 bg-muted/50 p-3 shrink-0">
        <p className="text-xs text-muted-foreground text-center font-medium">Teertham Admin v1.0</p>
      </div>
    </aside>
  )
}
